@csrf

@php
  $currencies = \App\Models\Currency::orderByDesc('is_primary')->orderBy('code')->get();
  $defaultCurrency = optional($currencies->firstWhere('is_primary',true))->id;
  $currencyRates = $currencies->map(fn($c)=>[
    'id' => $c->id,
    'code' => $c->code,
    'rate' => (float)$c->rate_to_primary,
    'is_primary' => (bool)$c->is_primary,
  ]);
@endphp

<div class="grid grid-cols-1 md:grid-cols-4 gap-3">
  <div>
    <label class="block text-sm font-medium text-gray-700">Nombre</label>
    <input name="name" class="mt-1 block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500" value="{{ old('name', $product->name ?? '') }}" required>
  </div>

  <div>
    <label class="block text-sm font-medium text-gray-700">Categoría</label>
    <select name="category_id" class="mt-1 block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500" required>
      <option value="">Seleccione</option>
      @foreach($categories as $c)
        <option value="{{ $c->id }}" @selected(old('category_id', $product->category_id ?? '')==$c->id)>{{ $c->name }}</option>
      @endforeach
    </select>
  </div>

  <div>
    <label class="block text-sm font-medium text-gray-700">SKU</label>
    <input name="sku" class="mt-1 block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500" value="{{ old('sku', $product->sku ?? '') }}" required>
  </div>

  <div>
    <label class="block text-sm font-medium text-gray-700">Código de barra</label>

    <!-- Input alineado + botones como append -->
    <div class="mt-1 flex gap-2 items-stretch">
      <input type="text"
             name="barcode"
             id="barcode-input"
             class="block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500"
             value="{{ old('barcode', $product->barcode ?? '') }}"
             placeholder="Ej. 7501031311309 / interno">

      <!-- Botones (si no hay barcode aún, arrancan ocultos) -->
      <a class="inline-flex items-center gap-2 rounded-lg border border-blue-500 text-blue-600 px-3 text-sm hover:bg-blue-50 {{ empty($product->barcode)?'hidden':'' }}"
         href="{{ isset($product->barcode) ? route('zapatera.admin.barcode.thermal', ['code'=>$product->barcode]) : '#' }}"
         target="_blank" id="barcode-thermal">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"/></svg>
        HTML
      </a>
      <a class="inline-flex items-center gap-2 rounded-lg border border-gray-600 text-gray-700 px-3 text-sm hover:bg-gray-50 {{ empty($product->barcode)?'hidden':'' }}"
         href="{{ isset($product->barcode) ? route('zapatera.admin.barcode.zplOne', ['code'=>$product->barcode]) : '#' }}"
         target="_blank" id="barcode-zpl">
         ZPL
      </a>
    </div>

    <div class="mt-1 text-xs text-gray-500">Puedes dejarlo vacío y asignarlo más tarde.</div>

    <!-- Vista previa compacta -->
    <div id="barcode-preview-wrap" class="mt-2 hidden rounded-lg border border-gray-200 overflow-hidden">
      <div class="px-2 py-1 flex items-center justify-between bg-gray-50">
        <strong class="text-xs">Vista previa del código</strong>
        <span class="text-xs text-gray-500" id="barcode-preview-hint"></span>
      </div>
      <div class="p-2">
        <div id="barcode-preview-ajax" class="text-center"></div>
      </div>
    </div>
  </div>
</div>

<div class="mt-3">
  <label class="block text-sm font-medium text-gray-700">Descripción</label>
  <textarea name="description" class="mt-1 block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500" rows="3">{{ old('description', $product->description ?? '') }}</textarea>
</div>

<div class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4 items-start">
  <!-- Columna izquierda: costo + precio + ganancia -->
  <div class="space-y-4">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 items-end">
      <div>
        <label class="block text-sm font-medium text-gray-700">Costo</label>
        <div class="mt-1 flex gap-2">
          <input id="cost" type="number" step="0.01" name="cost" class="w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500"
                 value="{{ old('cost', $product->cost ?? 0) }}">
          <select id="cost_currency_id" name="cost_currency_id" class="w-28 rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500">
            @foreach($currencies as $c)
              <option value="{{ $c->id }}"
                      @selected(old('cost_currency_id', $product->cost_currency_id ?? $defaultCurrency)==$c->id)>
                {{ $c->code }}
              </option>
            @endforeach
          </select>
        </div>
      </div>

      <div>
        <label class="block text-sm font-medium text-gray-700">Precio base</label>
        <div class="mt-1 flex gap-2">
          <input id="base_price" type="number" step="0.01" name="base_price" class="w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500"
                 value="{{ old('base_price', $product->base_price ?? 0) }}" required>
          <select id="base_price_currency_id" name="base_price_currency_id" class="w-28 rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500">
            @foreach($currencies as $c)
              <option value="{{ $c->id }}"
                      @selected(old('base_price_currency_id', $product->base_price_currency_id ?? $defaultCurrency)==$c->id)>
                {{ $c->code }}
              </option>
            @endforeach
          </select>
        </div>
      </div>

      <div class="md:col-span-2">
        <label class="block text-sm font-medium text-gray-700">Ganancia</label>
        <div id="profit-text" class="mt-1 rounded-lg border border-gray-200 bg-gray-50 p-2 text-sm">—</div>
      </div>
    </div>
  </div>

  {{-- Columna derecha: subcategorías --}}
  <div>
    <label class="block text-sm font-medium text-gray-700">Subcategorías (Atributos)</label>

    {{-- contenedor con altura y scroll responsivo --}}
    <div class="mt-1 rounded-lg border border-gray-200 p-3 max-h-72 sm:max-h-80 overflow-auto">
      {{-- grupos: 1 col en móvil, 2 en sm, 3 en lg --}}
      <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
        @foreach($attributes as $attr)
          <fieldset class="rounded-md border border-gray-100 p-3">
            <legend class="px-1 text-xs font-semibold text-gray-700">{{ $attr->name }}</legend>

            {{-- valores: auto-fit para que bajen a otra fila sin romperse --}}
            <div class="mt-2 grid gap-2 [grid-template-columns:repeat(auto-fit,minmax(120px,1fr))]">
              @foreach($attr->values as $val)
                @php
                  $checked = in_array($val->id, old('attribute_values', $selectedAttributeValues ?? []));
                @endphp
                <label class="inline-flex items-center gap-2 rounded-md border border-gray-200 bg-white px-2.5 py-1.5 text-sm hover:bg-slate-50">
                  <input
                    class="rounded border-gray-300 text-blue-600 focus:ring-blue-500"
                    type="checkbox"
                    name="attribute_values[]"
                    value="{{ $val->id }}"
                    {{ $checked ? 'checked' : '' }}>
                  <span class="truncate text-gray-700">{{ $val->value }}</span>
                </label>
              @endforeach
            </div>
          </fieldset>
        @endforeach
      </div>
    </div>

    <div class="mt-1 text-xs text-gray-500">
      Un producto tiene 1 categoría principal y múltiples subcategorías.
    </div>
  </div>

</div>

<div class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4">
  <div>
    <label class="block text-sm font-medium text-gray-700">Imágenes</label>

    <!-- Dropzone bonito -->
    <div id="nlx-uploader"
         class="mt-1 relative rounded-2xl border-2 border-dashed border-gray-300 bg-gray-50 p-6 text-center">
      <div class="flex flex-col items-center gap-2">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 15a4 4 0 004 4h10a4 4 0 004-4M7 10l5-5m0 0l5 5m-5-5v12"/></svg>
        <div class="font-medium text-gray-700">Arrastra tus imágenes aquí</div>
        <div class="text-xs text-gray-500">o</div>
        <button type="button" id="nlx-browse" class="inline-flex items-center justify-center rounded-lg border border-blue-500 px-3 py-1.5 text-sm text-blue-600 hover:bg-blue-50">
          Elegir archivos
        </button>
        <div class="text-xs text-gray-500">JPG, PNG, WEBP · Máx <span id="nlx-max-mb">5</span> MB c/u · Múltiples permitidas</div>
        <div class="mt-1 text-xs">
          <span class="inline-flex items-center gap-1 rounded-full bg-gray-200 px-2 py-0.5 text-gray-700">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7h18M3 12h18M3 17h18"/></svg>
            <span id="nlx-count">0</span> seleccionadas
          </span>
        </div>
      </div>

      <!-- Input real (oculto) que Laravel recibe -->
      <input id="nlx-input" type="file" name="images[]" accept="image/*" multiple class="hidden">
    </div>

    <!-- Grid de previews -->
    <div id="nlx-previews" class="mt-2 grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-2"></div>

    <div class="mt-2 text-xs text-gray-500">
      Puedes subir varias imágenes. Luego, debajo, eliges la principal o eliminas existentes.
    </div>
  </div>

  @isset($media)
    <div class="space-y-4">
      <div>
        <label class="block text-sm font-medium text-gray-700">Seleccionar imagen principal</label>
        <div class="mt-1 flex flex-wrap gap-3">
          @foreach($media as $m)
            @php
              $raw = trim($m->path ?? '');
              $url = null;
              if ($raw !== '') {
                if (preg_match('~^https?://~i', $raw)) {
                  $url = $raw; // URL absoluta (S3/CDN)
                } elseif (str_starts_with($raw, 'public/storage/')) {
                  $publicPath = substr($raw, 7); // quita 'public/'
                  if (file_exists(public_path($publicPath))) {
                    $url = asset($publicPath);
                  }
                } elseif (str_starts_with($raw, 'storage/')) {
                  if (file_exists(public_path($raw))) {
                    $url = asset($raw);
                  }
                } else {
                  if (\Storage::disk('public')->exists($raw)) {
                    $url = \Storage::url($raw); // /storage/...
                  } elseif (file_exists(public_path($raw))) {
                    $url = asset($raw);
                  }
                }
              }
              $url = $url ?: asset('img/placeholder_zapato_detalle.svg');
            @endphp

            <label class="inline-flex flex-col items-center gap-2 rounded-lg border border-gray-200 p-2">
              <img src="{{ $url }}" data-enlargeable class="h-[90px] w-[120px] object-cover rounded cursor-zoom-in" alt="imagen">
              <input type="radio" name="primary_media_id" value="{{ $m->id }}" @checked($m->is_primary)>
              <small class="text-gray-500">#{{ $m->id }}</small>
            </label>
          @endforeach
        </div>
      </div>

      <div>
        <label class="block text-sm font-medium text-gray-700">Eliminar imágenes</label>
        <div class="mt-1 flex flex-wrap gap-4">
          @foreach($media as $m)
            <label class="inline-flex items-center gap-2 text-sm">
              <input type="checkbox" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500" name="delete_media_ids[]" value="{{ $m->id }}">
              <span class="text-gray-700">Eliminar #{{ $m->id }}</span>
            </label>
          @endforeach
        </div>
        <div class="mt-1 text-xs text-gray-500">Marca las imágenes a eliminar y guarda para aplicar cambios.</div>
      </div>
    </div>
  @endisset
</div>

<div class="mt-4 flex items-center gap-2">
  <button class="inline-flex items-center justify-center rounded-lg bg-blue-600 px-4 py-2 text-white hover:bg-blue-700">Guardar</button>
  <a href="{{ route('zapatera.admin.products.index') }}" class="inline-flex items-center justify-center rounded-lg border border-gray-300 px-4 py-2 text-gray-700 hover:bg-gray-50">Cancelar</a>
</div>

<!-- Lightbox (remplaza modal de Bootstrap) -->
<div id="nlx-lightbox" class="nlx-lightbox hidden">
  <div class="nlx-lightbox-backdrop"></div>
  <div class="nlx-lightbox-body">
    <button type="button" class="nlx-lightbox-close" aria-label="Cerrar">×</button>
    <img id="nlx-lightbox-img" alt="vista ampliada" />
  </div>
</div>

@push('styles')
<style>
  /* Lightbox */
  .nlx-lightbox { position: fixed; inset: 0; z-index: 50; }
  .nlx-lightbox.hidden { display: none; }
  .nlx-lightbox-backdrop { position: absolute; inset: 0; background: rgba(0,0,0,.65); backdrop-filter: blur(1px); }
  .nlx-lightbox-body { position: absolute; inset: 0; display:flex; align-items:center; justify-content:center; padding: 16px; }
  .nlx-lightbox-body img { max-width: min(96vw, 1100px); max-height: 90vh; border-radius: 10px; box-shadow: 0 10px 40px rgba(0,0,0,.5); background: #fff; }
  .nlx-lightbox-close { position: absolute; top: 12px; right: 16px; border: 0; background: #fff; color:#000; font-size: 28px; line-height: 1; width: 40px; height: 40px; border-radius: 50%; cursor: pointer; box-shadow: 0 2px 12px rgba(0,0,0,.3); }

  /* Barcode preview */
  #barcode-preview-ajax svg { width: 100%; max-width: 420px; height: 52px; }
  .nlx-spinner { width: 22px; height: 22px; border-radius: 50%; border: 3px solid #e5e7eb; border-top-color: #2563eb; animation: spin .8s linear infinite; display:inline-block; }
  @keyframes spin { to { transform: rotate(360deg);} }

  /* Uploader thumbs */
  .nlx-thumb { position: relative; overflow: hidden; }
</style>
@endpush

@push('scripts')
<script>
(() => {
  try {
    window.currencyRates = Array.isArray(window.currencyRates) && window.currencyRates.length
      ? window.currencyRates
      : @json($currencyRates ?? []);
  } catch (e) {
    window.currencyRates = window.currencyRates || [];
  }

  const $ = (id) => document.getElementById(id);
  const debounce = (fn, ms=140) => { let t; return (...a)=>{ clearTimeout(t); t=setTimeout(()=>fn(...a), ms); }; };
  const log = (...args) => console.debug('[profit]', ...args);

  let tries = 0;
  const maxTries = 50; {{-- ~5s a 100ms --}}
  function startWhenReady() {
    console.warn('Depurando SCRIPT');
    const costEl     = $('cost');
    const costCurEl  = $('cost_currency_id');
    const baseEl     = $('base_price');
    const baseCurEl  = $('base_price_currency_id');
    const out        = $('profit-text');

    if (!costEl || !costCurEl || !baseEl || !baseCurEl || !out) {
      if (tries++ < maxTries) return setTimeout(startWhenReady, 100);
      log('No encontré elementos necesarios. Abortando.');
      return;
    }

    if (out.dataset.profitInit === '1') {
      log('Ya inicializado. Skip.');
      return;
    }
    out.dataset.profitInit = '1';

    const rates   = Array.isArray(window.currencyRates) ? window.currencyRates : [];
    const primary = rates.find(x => x && x.is_primary) || null;

    const find = (id) => rates.find(x => String(x.id) === String(id)) || {};
    const rate = (id) => Number(find(id).rate || 0);
    const code = (id) => find(id).code || '';

    const nf = new Intl.NumberFormat(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    const fmt = (n) => nf.format(Number(n) || 0);

    const badge = (n, lbl='') => {
      const ok = (Number(n)||0) >= 0;
      return `<span class="inline-flex items-center rounded px-1.5 py-0.5 text-xs ${ok ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'}">${fmt(n)}${lbl ? ' ' + lbl : ''}</span>`;
    };

    function calc() {
      console.log('function calc()');
      const cost    = Number(costEl.value) || 0;
      const base    = Number(baseEl.value) || 0;
      const costCur = costCurEl.value;
      const baseCur = baseCurEl.value;

      if (!cost && !base) { out.textContent = '—'; return; }

      const rCost = rate(costCur) || 1;
      const rBase = rate(baseCur) || 1;

      const costP   = cost * rCost;
      const baseP   = base * rBase;
      const profitP = baseP - costP;

      if (costCur === baseCur) {
        out.innerHTML = `Ganancia: <strong>${badge(base - cost, code(costCur))}</strong>`;
        return;
      }

      const profitInBase = rBase ? (profitP / rBase) : 0;
      const profitInCost = rCost ? (profitP / rCost) : 0;
      const pCode        = primary?.code || 'PRINC';

      out.innerHTML = [
        `Ganancia en ${pCode}: <strong>${badge(profitP, primary?.code || '')}</strong>`,
        `≈ en ${code(baseCur)}: <strong>${badge(profitInBase, code(baseCur))}</strong>`,
        `≈ en ${code(costCur)}: <strong>${badge(profitInCost, code(costCur))}</strong>`
      ].join('<br>');
    }

    const onChange = debounce(calc, 120);
    [costEl, costCurEl, baseEl, baseCurEl].forEach(el => {
      el.addEventListener('input', onChange, { passive: true });
      el.addEventListener('change', onChange);
    });

    {{-- Hacer accesible manualmente si otro módulo necesita recalcular --}}
    window.recalcProfit = calc;

    calc();
    log('Inicializado OK');
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', startWhenReady);
  } else {
    startWhenReady();
  }

  window.addEventListener('turbo:load', startWhenReady);
  document.addEventListener('livewire:navigated', startWhenReady);
})();
</script>
@endpush



@push('scripts')
<script>
// ==== Lightbox vanilla ====
document.addEventListener('DOMContentLoaded', function () {
  const $lb     = document.getElementById('nlx-lightbox');
  const $lbImg  = document.getElementById('nlx-lightbox-img');
  const $lbBack = $lb?.querySelector('.nlx-lightbox-backdrop');
  const $lbX    = $lb?.querySelector('.nlx-lightbox-close');

  if (!$lb || !$lbImg) return;

  function openLightbox(src) {
    $lbImg.src = '';
    $lb.classList.remove('hidden');
    fetch(src, { cache: 'no-store' })
      .then(r => r.blob())
      .then(blob => $lbImg.src = URL.createObjectURL(blob))
      .catch(() => { $lbImg.src = src; });
  }

  function closeLightbox() {
    $lb.classList.add('hidden');
    if ($lbImg.src.startsWith('blob:')) URL.revokeObjectURL($lbImg.src);
    $lbImg.src = '';
  }

  $lbBack?.addEventListener('click', closeLightbox);
  $lbX?.addEventListener('click', closeLightbox);
  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape' && !$lb.classList.contains('hidden')) closeLightbox();
  });

  const grids = [ document.getElementById('nlx-previews'), document ];
  grids.forEach(root => {
    if (!root) return;
    root.addEventListener('click', (e) => {
      const img = e.target.closest('img[data-enlargeable]');
      if (!img) return;
      e.preventDefault();
      const src = img.getAttribute('src');
      if (!src) return;
      openLightbox(src);
    }, true);
  });
});
</script>
@endpush

@push('scripts')
<script>
// ==== Botones de BarCode (toggle Tailwind hidden) ====
document.addEventListener('DOMContentLoaded', function () {
  const $input   = document.getElementById('barcode-input');
  const $wrap    = document.getElementById('barcode-preview-wrap');
  const $box     = document.getElementById('barcode-preview-ajax');
  const $hint    = document.getElementById('barcode-preview-hint');
  const $thermal = document.getElementById('barcode-thermal');
  const $zpl     = document.getElementById('barcode-zpl');

  if (!$input || !$box) return;

  const buildPreviewUrl = (code) => {
    const tpl = "{{ route('zapatera.admin.barcode.preview', ['code' => '__CODE__']) }}";
    return tpl.replace('__CODE__', encodeURIComponent(code));
  };
  const buildThermalUrl = (code) => {
    const tpl = "{{ route('zapatera.admin.barcode.thermal', ['code' => '__CODE__']) }}";
    return tpl.replace('__CODE__', encodeURIComponent(code));
  };
  const buildZplUrl = (code) => {
    const tpl = "{{ route('zapatera.admin.barcode.zplOne', ['code' => '__CODE__']) }}";
    return tpl.replace('__CODE__', encodeURIComponent(code));
  };

  async function renderBarcode(code) {
    $box.innerHTML = '<span class="nlx-spinner" aria-label="cargando"></span>';
    $hint.textContent = code;
    try {
      const res = await fetch(buildPreviewUrl(code), { headers: { 'Accept': 'image/svg+xml' }});
      if (!res.ok) throw new Error('HTTP '+res.status);
      const svgText = await res.text();
      $box.innerHTML = svgText;
    } catch (e) {
      $box.innerHTML = '<div class="text-red-600 text-sm">No se pudo generar el código.</div>';
    }
  }

  let t = null;
  const onChange = () => {
    const code = ($input.value || '').trim();
    if (code.length >= 5) {
      $wrap.classList.remove('hidden');
      renderBarcode(code);
      if ($thermal) { $thermal.href = buildThermalUrl(code); $thermal.classList.remove('hidden'); }
      if ($zpl)     { $zpl.href     = buildZplUrl(code);     $zpl.classList.remove('hidden'); }
    } else {
      $wrap.classList.add('hidden');
      if ($thermal) $thermal.classList.add('hidden');
      if ($zpl)     $zpl.classList.add('hidden');
    }
  };

  $input.addEventListener('input', () => { clearTimeout(t); t = setTimeout(onChange, 180); });

  const initial = ($input.value || '').trim();
  if (initial.length >= 5) { $wrap.classList.remove('hidden'); renderBarcode(initial); }
});
</script>
@endpush

@push('scripts')
<script>
// ==== InputFile Bonito (Tailwind) ====
(function(){
  const $drop   = document.getElementById('nlx-uploader');
  const $input  = document.getElementById('nlx-input');
  const $browse = document.getElementById('nlx-browse');
  const $prevs  = document.getElementById('nlx-previews');
  const $count  = document.getElementById('nlx-count');
  const $maxMb  = document.getElementById('nlx-max-mb');

  const MAX_MB   = 5;
  const ACCEPTED = ['image/jpeg','image/png','image/webp'];
  $maxMb.textContent = MAX_MB;

  const dt = new DataTransfer();

  function updateInputFiles() {
    $input.files = dt.files;
    $count.textContent = dt.files.length;
  }

  function fmtBytes(bytes) {
    const kb = bytes / 1024;
    if (kb < 1024) return `${kb.toFixed(0)} KB`;
    return `${(kb/1024).toFixed(2)} MB`;
  }

  function addFiles(fileList) {
    [...fileList].forEach(file => {
      if (!ACCEPTED.includes(file.type)) { toast(`Tipo no permitido: ${file.name}`); return; }
      if ((file.size/1024/1024) > MAX_MB) { toast(`Archivo demasiado grande (> ${MAX_MB}MB): ${file.name}`); return; }
      const dup = [...dt.files].find(f => f.name === file.name && f.size === file.size);
      if (dup) return;
      dt.items.add(file);
      renderPreview(file);
    });
    updateInputFiles();
  }

  function renderPreview(file) {
    const wrap = document.createElement('div');
    wrap.className = 'nlx-thumb rounded-lg overflow-hidden relative bg-white border border-gray-200';

    const img = document.createElement('img');
    img.alt = file.name;
    img.setAttribute('data-enlargeable','');
    img.className = 'w-full h-36 object-cover cursor-zoom-in';

    const reader = new FileReader();
    reader.onload = e => { img.src = e.target.result; };
    reader.readAsDataURL(file);

    const remove = document.createElement('button');
    remove.type = 'button';
    remove.className = 'nlx-remove absolute top-2 right-2 inline-flex items-center justify-center rounded-full bg-red-600/90 text-white w-7 h-7';
    remove.innerHTML = '×';
    remove.addEventListener('click', () => {
      for (let i = 0; i < dt.items.length; i++) {
        const f = dt.items[i].getAsFile();
        if (f.name === file.name && f.size === file.size) { dt.items.remove(i); break; }
      }
      updateInputFiles();
      col.remove();
    });

    const meta = document.createElement('div');
    meta.className = 'flex items-center justify-between px-2 py-1 text-xs text-gray-600';
    meta.innerHTML = `<span class="truncate max-w-[70%]">${file.name}</span><span>${fmtBytes(file.size)}</span>`;

    const col = document.createElement('div');
    col.appendChild(wrap);
    col.appendChild(meta);

    wrap.appendChild(img);
    wrap.appendChild(remove);

    const cell = document.createElement('div');
    cell.className = '';
    const container = document.createElement('div');
    container.appendChild(col);

    $prevs.appendChild(container);
  }

  ['dragenter','dragover'].forEach(evt =>
    $drop.addEventListener(evt, e => { e.preventDefault(); e.stopPropagation(); $drop.classList.add('ring-2','ring-blue-400'); })
  );
  ['dragleave','dragend','drop'].forEach(evt =>
    $drop.addEventListener(evt, e => { e.preventDefault(); e.stopPropagation(); $drop.classList.remove('ring-2','ring-blue-400'); })
  );
  $drop.addEventListener('drop', e => { addFiles(e.dataTransfer.files); });

  $browse.addEventListener('click', () => $input.click());
  $drop.addEventListener('click', (e) => { if (e.target === $drop) $input.click(); });

  $input.addEventListener('change', () => addFiles($input.files));

  function toast(msg) { console.warn(msg); }
})();
</script>
@endpush

@push('scripts')
<script>
// Exponer rates al front
window.currencyRates = @json($currencyRates);
</script>
@endpush
